<?php defined('SYSPATH') or die('No direct script access.');

/**
 * Available params:
 *
 * For access
 * php index.php --task=indexer:prepare --type=access
 *
 * For history
 * php index.php --task=indexer:prepare --type=history
 *
 * For logpost
 * php index.php --task=indexer:prepare --type=logpost
 */
class Task_Indexer_Prepare extends Minion_Task {

    protected $_options = array(
        'type'  => NULL
    );

    protected function _execute(array $params){
        if($params['type'] == 'null'){
            $params['type'] = 'new_sphinx';
        }elseif(!in_array($params['type'], ['access', 'logpost', 'history'])){
            Minion_CLI::write('Input valid type, see --help');
            exit;
        }

        $default1 = [
            '/home/storage_ex/'.$params['type'],
            '/home/storage_ex/'.$params['type'].'/bin',
            '/home/storage_ex/'.$params['type'].'/pid',
            '/home/storage_ex/'.$params['type'].'/logs',
        ];
        $default2 = [0, 20, 40, 60, 80, 'bin', 'pid'];
        $list = Kohana::$config->load('prepare');

        foreach($default1 as $d){
            $this->createDir($d);
        }

        foreach($list as $k => $l){
            $this->createDir('/home/storage_ex/'.$params['type'].'/'.$l);
            foreach($default2 as $d){
                $this->createDir('/home/storage_ex/'.$params['type'].'/'.$l.'/'.$d);

                $startId = $k + $d;
                $endId = $startId + 20;

                if(is_int($d)){
                    try {
                        if ($params['type'] == 'access') {
                            $this->seedMinMaxIdsAccess($startId, $endId);
                        }elseif($params['type'] == 'history'){
                            $this->seedMinMaxIdsHistory($startId, $endId);
                        }else{
                            $this->seedMinMaxIds($startId, $endId);
                        }
                    } catch (Exception $e){
                        Minion_CLI::write('Table not found. Try run migration..');
                        Minion_Task::factory(['db:migrate'])->execute();
                        Minion_CLI::write('Retry..');
                        $this->seedMinMaxIds($startId, $endId);
                    }
                }
            }
        }
    }

    private function seedMinMaxIdsAccess($startId, $endId){
        DB::insert('counter', ['name', 'id'])->values(['a_'.$startId.'_'.$endId, $startId*1000000])->execute();
    }

    private function seedMinMaxIdsHistory($startId, $endId){
        DB::insert('counter', ['name', 'id'])->values(['h_'.$startId.'_'.$endId, $startId*1000000])->execute();
    }

    private function seedMinMaxIds($startId, $endId){
        DB::insert('counter', ['name', 'id'])->values(['l_'.$startId.'_'.$endId, $startId*1000000])->execute();
    }

    private function createDir($path){
        if(!is_dir($path) && !file_exists($path)){
            mkdir($path);
        }
    }
}